import API from '@/api/equipment'
import {Message} from 'element-ui'

export default {
    /*---------------------------------工步关联设备模块-----------------------------------*/
    // 获取未关联工步的设备列表
    getStepUnassociatedDeviceList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepUnassociatedDeviceList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------设备分类数据-----------------------------------*/
    // 获取设备分类列表
    getClassificationList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getClassificationList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取左侧树列表数据
    getTreeList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getTreeList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑分类左侧树列表
    updateTree ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateTree(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增分类左侧树列表
    addTree ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addTree(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除分类左侧树列表
    detailTree ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.detailTree(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 启用、停用 设备分类列表数据
    disableEquipment ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.disableEquipment(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增设备分类列表数据
    addClassification ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addClassification(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑设备分类列表
    updateClassification ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateClassification(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除设备分类列表
    deleteClassificationList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteClassificationList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据ID获取编辑列表数据
    getUpdateClassificationList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getUpdateClassificationList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------设备档案数据-----------------------------------*/
    // 获取分类视图数据
    getCategoryViewList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getCategoryViewList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取部门视图数据
    getDepartmentViewList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getDepartmentViewList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取档案列表数据
    getArchivesList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getArchivesList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增设备档案
    addArchives ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addArchives(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除设备档案
    deleteArchives ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteArchives(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑设备档案
    updateArchives ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateArchives(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增档案时设备分类的数据
    getEquipmentTypeList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentTypeList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取编辑时的档案详情
    getEditArchivesDetailList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEditArchivesDetailList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------设备投运数据-----------------------------------*/
    // 新设备投运
    newCommissioned ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.newCommissioned(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 设备退运
    returnCommissioned ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.returnCommissioned(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 设备报障
    equipmentReporting ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.equipmentReporting(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
