import demandApi from '@/api/demand'
import {Message} from 'element-ui'

export default {
    // 获取需求处理列表
    getDisposeList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            demandApi.getDisposeList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 获取需求上报列表
    getReportList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            demandApi.getReportList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 创建产能、需求上报
    saveAddReport ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            demandApi.saveAddReport(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 创建并提交产能、需求上报
    postAddReport ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            demandApi.postAddReport(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 提交并撤回上报
    postOrRetractReport ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            demandApi.postOrRetractReport(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 编辑上报
    editAddReport ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            demandApi.editAddReport(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 删除上报
    deleteReport ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            demandApi.deleteReport(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 获取上报详情
    getReportDetail ({commit, state}, queryParam) {
        return new Promise((resolve, reject) => {
            demandApi.getReportDetail(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 发布产能、需求上报
    publishOrReturnReport ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            demandApi.publishOrReturnReport(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    }
}
