import API from '@/api/course'
import {Message} from 'element-ui'
// actions
export default {
    /*--------------------------------------工单管理-----------------------------------------*/
    // 获取工单列表
    getOrderList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getOrderList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增工单
    addOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 编辑工单
    updateOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除工单
    deleteOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取流转单列表数据
    getFlowOrderList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getFlowOrderList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增流转单
    addFlowOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addFlowOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 编辑流转单
    updateFlowOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateFlowOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除流转单
    deleteFlowOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteFlowOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 批量派发流转单
    batchDistributedFlowOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.batchDistributedFlowOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 批量打印流转单
    batchPrintFlowOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.batchPrintFlowOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 打印流转单
    printFlowOrder ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.printFlowOrder(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 查询打印机模板列表数据
    getPrintTemplateList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getPrintTemplateList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 工序记录列表数据
    getProcessRecordList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getProcessRecordList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 工步记录列表数据
    getStepRecordList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getStepRecordList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*--------------------------------------数据文件-----------------------------------------*/
    // 获取数据列表数据
    getDataFileList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDataFileList(queryParam).then(response => {
                resolve(response.data)
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    getDataFilePageList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDataFilePageList(queryParam).then(response => {
                resolve(response.data)
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 下载数据列表数据
    downloadDataFile ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDataFileList(queryParam).then(response => {
                resolve(response.data)
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
