import API from '@/api/capacity'
import {Message} from 'element-ui'

export default {
    // 根据产线id获取产能列表
    getCapacityListByProductionLineId ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getCapacityListByProductionLineId(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据工位id获取产能列表
    getCapacityListByStationId ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getCapacityListByStationId(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取列表
    getCapacityList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getCapacityList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增产能
    addCapacity ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addCapacity(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 批量新增产能
    batchAddCapacity ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.batchAddCapacity(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 修改产能数据
    updateCapacity ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateCapacity(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除产能
    deleteCapacity ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteCapacity(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
