
# 业务组件 - 搜索

**此搜索组件是针对列表页面中搜索功能薄弱问题，进行二次封装的业务组件**

主要功能有四部分组成
1. 字段列表
2. 字段的匹配规则
3. 字段所对应的值
4. 搜索和重置

### demo示例
[![](demo1.png)](demo1.png "markdown")
[![](demo2.png)](demo2.png "markdown")


### demo代码

```html
<Search
    searchCode="MATERIEL_RECORD"
    @search="searchClick"
    @reset="resetClick">
</Search>

```

```javascript
import Search from '../../components/Search'
export default {
    components: {
        Search
    },
    methods: {
        searchClick (param) {
            console.info(param)
        },
        resetClick (param) {
            console.info(param)
        }
    }
}
```

