import request from '@/utils/request'

export default {
    // 获取当前用户可查询的资源列表
    getResourceList (queryParams) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/user/${queryParams.userId}/resource`,
            method: 'GET',
            data
        })
    },
    // 获取某用户所有的角色
    getUserRoleList (queryParams) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/user/${queryParams.userId}/role`,
            method: 'GET',
            data
        })
    },
    // 获取某用户所有的数据权限
    getDataPermissionList (queryParams) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/user/${queryParams.userId}/user/data`,
            method: 'GET',
            data
        })
    },
    // 获取某个用户的所属用户组的数据
    geDepartmentLine (queryParams) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/user/${queryParams.userId}/user/group`,
            method: 'GET',
            data
        })
    },
    // 获取某个用户的数据权限的部门列表
    getDataDepartment (queryParams) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/user/${queryParams.userId}/group/data`,
            method: 'GET',
            data
        })
    }
}
