import request from '@/utils/request';

export default {
    /*---------------------------------工艺路线-----------------------------------*/
    // 新增工艺
    addProcess (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/create`,
            method: 'post',
            data
        })
    },
    // 获取工艺列表数据
    getProcessList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/page`,
            method: 'get',
            data
        })
    },
    // 编辑工艺路线
    updateProcess (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/update`,
            method: 'put',
            data
        })
    },
    // 删除工艺路线
    deleteProcess (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/delete/${queryParams.id}`,
            method: 'delete',
            data
        })
    },
    // 根据ID请求工艺路线数据
    getIdProcessList (queryParams) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/findById/${queryParams.id}`,
            method: 'GET',
            data
        })
    },
    // 发起审批接口
    processCheck (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/check`,
            method: 'put',
            data
        })
    },
    // 版本升级
    routingUpgrade (id) {
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/upgrade/${id}`,
            method: 'post',
            data: {}
        })
    },
    // 复制工艺路线
    copyProcess (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/copy`,
            method: 'post',
            data
        })
    },
    // 切换工艺路线生效状态
    changeProcessStatus (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/check`,
            method: 'put',
            data: queryParams
        })
    },
    // 工艺路线关联物料
    addProcessMateriel (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/materielRelation/${queryParams.id}`,
            method: 'post',
            data: queryParams.materielList
        })
    },
    // 删除工艺路线关联物料
    deleteProcessMateriel (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/delMaterielRelation`,
            method: 'delete',
            data: queryParams
        })
    },
    // 根据产线id获取它的工艺路线
    getListByProductionLineId (id) {
        return request({
            url: `${process.env.API_HOST}/api/craftsRoute/findByProLineId/${id}`,
            method: 'get',
            data: {}
        })
    },
    /*---------------------------------工序管理-----------------------------------*/
    // 获取工序列表数据
    getCraftsList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/getByRouteId/${queryParams.craftsRouteId}`,
            method: 'get',
            data
        })
    },
    // 新增工序
    addCrafts (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/create`,
            method: 'post',
            data
        })
    },
    // 删除工序
    deleteCrafts (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/${queryParams.id}`,
            method: 'delete',
            data
        })
    },
    // 编辑工序
    updateCrafts (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/update`,
            method: 'put',
            data
        })
    },
    // 工序排序
    sortCrafts (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/sort`,
            method: 'put',
            data
        })
    },
    // 根据ID获取工序详情数据
    getIdCraftsList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/getById/${queryParams.id}`,
            method: 'get',
            data
        })
    },
    // 获取前道工序数据
    getFrontCraftsList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/process/findBeforeProcess/${queryParams.craftsRouteId}`,
            method: 'get',
            data
        })
    },
    /*--------------------------------------------------工步列表--------------------------------------*/
    // 获取工步列表数据
    getStepList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/getByProcessId/${queryParams.processId}`,
            method: 'get',
            data
        })
    },
    // 新增工步
    addStep (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/create`,
            method: 'post',
            data
        })
    },
    // 删除工步
    deleteStep (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/${queryParams.id}`,
            method: 'delete',
            data
        })
    },
    // 编辑工步
    updateStep (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/update`,
            method: 'put',
            data
        })
    },
    // 工步排序
    workStepSort (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/sort`,
            method: 'put',
            data
        })
    },
    // 获取前道工步数据
    getFrontStepList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/findBeforeProcessStep/${queryParams.processId}`,
            method: 'get',
            data
        })
    },
    // 根据ID 获取工步数据
    getStepIdList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStep/getById/${queryParams.id}`,
            method: 'get',
            data
        })
    },
    // 根据工步ID 查询工步关联物料
    getStepAssociateMaterielList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepMateriel/pageByProcessStepId`,
            method: 'get',
            data
        })
    },
    // 新增工步关联物料
    addStepMateriel (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepMateriel/batchCreate`,
            method: 'post',
            data
        })
    },
    // 删除工步关联的物料
    deleteStepMateriel (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepMateriel/delete/${queryParams.processStepId}/${queryParams.code}`,
            method: 'delete',
            data
        })
    },
    // 根据工步ID查询质检工艺
    getStepQualityCrafts (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/processStepQualityCrafts/pageByProcessStepId`,
            method: 'get',
            data: queryParams
        })
    },
    // 新增工步关联质检
    addStepInspection (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepQualityCrafts/batchCreate`,
            method: 'post',
            data
        })
    },
    // 删除工步关联质检
    deleteStepInspection (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepQualityCrafts/delete/${queryParams.processStepId}/${queryParams.qualityCraftsCode}`,
            method: 'delete',
            data
        })
    },
    // 工步关联设备列表数据
    getStepAssociateDeviceList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepEquipment/pageByProcessStepId`,
            method: 'get',
            data
        })
    },
    // 删除工步关联设备
    deleteStepDevice (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepEquipment/delete/${queryParams.processStepId}/${queryParams.equipmentId}`,
            method: 'delete',
            data
        })
    },
    // 新增工步关联设备
    addStepDevice (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepEquipment/batchCreate`,
            method: 'post',
            data
        })
    },
    // 获取工步关联程序列表数据
    getStepAssociateProgramList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepProgram/pageByProcessStepId`,
            method: 'get',
            data
        })
    },
    // 删除工步关联程序
    deleteStepProgram (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepProgram/delete/${queryParams.processStepId}/${queryParams.equipmentId}/${queryParams.programCode}`,
            method: 'delete',
            data
        })
    },
    // 新增工步关联程序
    addStepProgram (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepProgram/batchCreate`,
            method: 'post',
            data
        })
    },
    /*---------------------------------质检工艺-----------------------------------*/
    // 获取质检工艺列表
    getInspectionList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/page`,
            method: 'get',
            data
        })
    },
    // 新增质检工艺
    addInspection (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/create`,
            method: 'post',
            data
        })
    },
    // 更新质检工艺
    updateInspection (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/update`,
            method: 'put',
            data
        })
    },
    // 删除质检工艺
    deleteInspection (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/delete/${queryParams.id}`,
            method: 'delete',
            data: {}
        })
    },
    // 获取一个质检工艺详情
    getInspection (id) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/findById/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 添加质检工艺检验项
    addQualityCraftsItem (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCraftsItem/create`,
            method: 'post',
            data: queryParams
        })
    },
    // 编辑质检工艺检验项
    editQualityCraftsItem (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCraftsItem/update`,
            method: 'put',
            data: queryParams
        })
    },
    // 删除质检工艺检验项
    deleteQualityCraftsItem (id) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCraftsItem/delete/${id}`,
            method: 'delete',
            data: {}
        })
    },
    // 升级质检工艺
    inspectionUpgrade (id) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/upgrade/${id}`,
            method: 'post',
            data: {}
        })
    },
    // 复制质检工艺
    copyInspection (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/copy`,
            method: 'post',
            data: queryParams
        })
    },
    // 切换质检工艺生效状态
    changeInspectionStatus (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/qualityCrafts/check`,
            method: 'put',
            data: queryParams
        })
    },
    // 根据工步ID分页查询所有未关联的质检工艺
    getStepQualityCraftsList (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/processStepQualityCrafts/page`,
            method: 'get',
            data: queryParams
        })
    },
    /*------------------------------------BOM管理---------------------------------------*/
    // 获取BOM列表数据
    getBomList (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/page`,
            method: 'get',
            data: queryParams
        })
    },
    // 新增BOM
    addBom (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/create`,
            method: 'post',
            data: queryParams
        })
    },
    // 编辑BOM
    updateBom (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/update`,
            method: 'put',
            data: queryParams
        })
    },
    // 删除BOM
    deleteBom (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/${queryParams.matBomId}`,
            method: 'delete',
            data: queryParams
        })
    },
    // 根据ID查询BOM数据
    findByIdBom (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/findById/${queryParams.id}`,
            method: 'get',
            data: queryParams
        })
    },
    // 通过BOM ID请求BOM节点数据
    getByBomIdNodeList (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBomDetail/getByBomId/${queryParams.bomId}`,
            method: 'get',
            data: queryParams
        })
    },
    // 版本升级
    bomUpgrade (id) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/upgrade/${id}`,
            method: 'post',
            data: {}
        })
    },
    // 复制BOM
    copyBom (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/copy`,
            method: 'post',
            data: queryParams
        })
    },
    // 切换BOM生效状态
    changeBomStatus (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBom/check`,
            method: 'put',
            data: queryParams
        })
    },
    // 新增BOM节点
    addBomNode (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBomDetail/create`,
            method: 'post',
            data: queryParams
        })
    },
    // 编辑BOM节点
    editBomNode (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBomDetail/update`,
            method: 'put',
            data: queryParams
        })
    },
    // 删除BOM节点
    deleteBomNode (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/matBomDetail/${queryParams.matBomDetailId}`,
            method: 'delete',
            data: queryParams
        })
    },
    /*--------------------------------------------程序管理---------------------------------------*/
    // 获取所有未关联工步的程序
    getStepUnassociatedProgramList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/processStepProgram/page`,
            method: 'get',
            data
        })
    },
    // 获取程序列表
    getProgramList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/crafts/program/page`,
            method: 'get',
            data
        })
    },
    // 新增程序
    addProgram (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/crafts/program`,
            method: 'post',
            data
        })
    },
    // 编辑程序
    updateProgram (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/crafts/program`,
            method: 'put',
            data
        })
    },
    // 删除程序
    deleteProgram (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/crafts/program/${param.programId}`,
            method: 'delete',
            data
        })
    },
    // 根据程序ID获取程序详情数据
    getProgramDetailsList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/crafts/program/${param.programId}`,
            method: 'get',
            data
        })
    },
    // 根据程序ID获取附件详情数据
    getProgramIdAnnexList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/programFile/${param.id}`,
            method: 'get',
            data
        })
    },
    // 韩国测试机程序下发
    sendKoreaTesterProgram (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/crafts/program/sendKoreaTesterProgram`,
            method: 'get',
            data
        })
    },
    /*-----------------------------------------------异构数据------------------------------------*/
    // 根据Id获取异构数据 程序
    getIsomerousList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/koreaTester/program/getById`,
            method: 'get',
            data
        })
    },
    // 根据code获取异构数据 程序
    getIsomerousListData (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/koreaTester/program/code`,
            method: 'get',
            data
        })
    },
    // NDF程序新增
    ndfInsert (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/koreaTester/program/ndf/insert`,
            method: 'post',
            data
        })
    },
    // NDF程序修改
    ndfUpdate (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/koreaTester/program/ndf/update`,
            method: 'put',
            data
        })
    },
    // NDF程序新增
    ndrInsert (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/koreaTester/program/ndr/insert`,
            method: 'post',
            data
        })
    },
    // NDF程序修改
    ndrUpdate (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/koreaTester/program/ndr/update`,
            method: 'put',
            data
        })
    }
}
