import request from '@/utils/request'

export default {
    /*------------------------------计划管理-------------------------------*/
    // 获取计划列表数据
    getPlanList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/queryPlan`,
            method: 'get',
            data
        })
    },
    // 获取计划详情列表
    getPlanDetailList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/queryPlanDetail`,
            method: 'get',
            data
        })
    },
    // 新增计划
    addPlan (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/createPlan`,
            method: 'post',
            data
        })
    },
    // 编辑计划
    editPlan (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/updatePlanOnly`,
            method: 'put',
            data
        })
    },
    // 删除计划
    delPlan (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/delPlan/${param.id}`,
            method: 'DELETE',
            data
        })
    },
    // 删除计划详情
    delPlanDetail (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/delPlanDetail/${param.id}`,
            method: 'DELETE',
            data
        })
    },
    // 修改计划详情
    updatePlanDetail (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/updatePlanDetail`,
            method: 'put',
            data
        })
    },
    /*------------------------------计划详情-------------------------------*/
    /*------------------------------计划拆分-------------------------------*/
    // 计划手动拆分
    handSplitPlan (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/handSplitPlan`,
            method: 'post',
            data
        })
    },
    // 计划手动拆分
    sendPlanDetail (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/plan/sendPlanDetail`,
            method: 'put',
            data
        })
    }
}
