import request from '@/utils/request';

export default {
    // 根据产线id获取产能列表
    getCapacityListByProductionLineId (id) {
        return request({
            url: `${process.env.API_HOST}/api/uph/getByProLineId/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 根据工位id获取产能列表
    getCapacityListByStationId (id) {
        return request({
            url: `${process.env.API_HOST}/api/uph/getByPositionId/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 获取列表
    getCapacityList (queryParam) {
        const data = queryParam;
        return request({
            url: `${process.env.API_HOST}/api/uph/page/materiel`,
            method: 'get',
            data
        })
    },
    // 新增产能
    addCapacity (queryParam) {
        const data = queryParam;
        return request({
            url: `${process.env.API_HOST}/api/uph/create`,
            method: 'post',
            data
        })
    },
    // 批量新增产能
    batchAddCapacity (queryParam) {
        const data = queryParam;
        return request({
            url: `${process.env.API_HOST}/api/uph/batchCreate`,
            method: 'post',
            data
        })
    },
    // 更新产能数据
    updateCapacity (queryParam) {
        const data = queryParam;
        return request({
            url: `${process.env.API_HOST}/api/uph/update`,
            method: 'put',
            data
        })
    },
    // 删除产能
    deleteCapacity (id) {
        return request({
            url: `${process.env.API_HOST}/api/uph/delete/${id}`,
            method: 'delete',
            data: {}
        })
    }
}
