import request from '@/utils/request';

export default {
    /*---------------------------------车间管理-----------------------------------*/
    // 获取车间列表
    getWorkshopList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workshop/all`,
            method: 'get',
            data
        })
    },
    // 新增车间
    addWorkshop (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workshop/create`,
            method: 'post',
            data
        })
    },
    // 编辑车间
    updateWorkshop (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workshop/update`,
            method: 'put',
            data
        })
    },
    // 删除车间
    deleteWorkshop (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/workshop/delete/${id}`,
            method: 'delete',
            data: {}
        })
    },
    /*---------------------------------产线管理-----------------------------------*/
    // 根据车间ID获取产线列表
    getProductionLineListById (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/getByWorkshopId/${id}`,
            method: 'get',
            data: []
        })
    },
    // 获取产线列表
    getProductionLineList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/page`,
            method: 'get',
            data
        })
    },
    // 新增产线
    addProductionLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/create`,
            method: 'post',
            data
        })
    },
    // 编辑产线
    updateProductionLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/update`,
            method: 'put',
            data
        })
    },
    // 删除产线
    deleteProductionLine (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/delete/${id}`,
            method: 'delete',
            data: {}
        })
    },
    // 产线取消关联的工位
    unlinkStation (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/delPositionRelation`,
            method: 'delete',
            data: data
        })
    },
    // 根据id获取产线详情
    getProductionLineById (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/findById/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 根据车间选取产线
    getShopProductionLineList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workshop/treeProLine`,
            method: 'get',
            data
        })
    },
    /*---------------------------------工位管理-----------------------------------*/
    // 根据产线id获取工位列表
    getStationListById (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/getByProLineId/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 获取工位列表
    getStationList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/page`,
            method: 'get',
            data
        })
    },
    // 获取工位详情
    getStationById (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/findById/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 获取待选工位
    getNoSelectedList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/getRelation/${data.proLineId}`,
            method: 'get',
            data
        })
    },
    // 新增工位
    addStation (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/create`,
            method: 'post',
            data
        })
    },
    // 编辑工位
    updateStation (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/update`,
            method: 'put',
            data
        })
    },
    // 删除工位
    deleteStation (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/delete/${id}`,
            method: 'delete',
            data: {}
        })
    },
    // /api/v2/proLine/delPositionRelation
    // 删除产线工位关联关系
    delPositionRelation (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/delPositionRelation`,
            method: 'delete',
            data: queryParams
        })
    },
    // 关联工位
    relevanceStation (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/v2/proLine/positionRelation/${queryParams.proLineId}`,
            method: 'post',
            data: queryParams.positionIds
        })
    },
    // 删除工位和设备的关联关系
    deleteStationDeviceRelation (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/delEquipmentRelation`,
            method: 'delete',
            data
        })
    },
    // 获取工位已关联的设备列表
    getStationAssociatedDevice (id) {
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/getEquipmentById/${id}`,
            method: 'get',
            data: {}
        })
    },
    // 获取工位未关联的设备列表
    getStationNoAssociatedDevice (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/pageEqpRelation`,
            method: 'get',
            data
        })
    },
    // 工位关联设备
    stationRelevanceDevice (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workStation/equipmentRelation/${queryParams.workPositionId}`,
            method: 'post',
            data: queryParams.equipmentIds
        })
    },
    // 获取工位对应的APP功能权限
    getAppFeatures (id) {
        return request({
            url: `${process.env.API_HOST}/api/workPositionButton/buttonAuthList`,
            method: 'get',
            data: {
                workPositionCode: id
            }
        })
    },
    // 保存工位对应的APP功能权限
    saveAppFeatures (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/workPositionButton`,
            method: 'post',
            data: queryParams
        })
    },
    /*---------------------------------------------托盘建档---------------------------------------------------*/
    // 获取托盘列表数据
    getTrayList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/tray/page`,
            method: 'get',
            data
        })
    },
    // 新增托盘
    addTray (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/tray/createTray`,
            method: 'post',
            data
        })
    },
    // 编辑托盘
    updateTray (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/tray/updateTrayInfo`,
            method: 'put',
            data
        })
    },
    // 删除托盘
    deleteTray (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/tray/deleteTrayByCode/${queryParams}`,
            method: 'delete',
            data
        })
    },
    /*---------------------------------------------工装夹具---------------------------------------------------*/
    // 获取工装夹具列表数据
    getFixtureList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/fixture/page`,
            method: 'get',
            data
        })
    },
    // 新增工装夹具
    addFixture (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/fixture/create`,
            method: 'post',
            data
        })
    },
    // 编辑工装夹具
    updateFixture (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/fixture/updateFixtureInfo`,
            method: 'put',
            data
        })
    },
    // 删除工装夹具
    deleteFixture (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/fixture/deletefixtureByCode/${queryParams}`,
            method: 'delete',
            data
        })
    }
}
