package net.vtstar.zhongtong.avi.stamping.job;

import lombok.extern.slf4j.Slf4j;
import net.vtstar.scada.base.equipmgt.domain.Enum.EquipStatusEnum;
import net.vtstar.scada.base.gather.domain.EquipmentData;
import net.vtstar.scada.base.gather.job.GatherJob;
import net.vtstar.zhongtong.avi.stamping.domain.LaserCuttingMachine;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.stereotype.Component;

/**
 * 激光切割机数据采集JOB
 */
@Slf4j
@Component
public class LaserCuttingMachineJob extends GatherJob {

    private static final String NAME = "3D_LASER_CUTTING";

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {

        log.info("JobName: {}", context.getJobDetail().getKey().getName());
        super.gatherByModbus(NAME, LaserCuttingMachine.class);
    }

    protected boolean handleObject(EquipmentData equipmentData) {

        LaserCuttingMachine data = (LaserCuttingMachine) equipmentData;
        Integer state = data.getState();
        if (state == null) {
            return false;
        }
        switch (state) {
            case 0:
                equipmentData.setEquipStatus(EquipStatusEnum.SHUTDOWN);
                break;
            case 1:
                equipmentData.setEquipStatus(EquipStatusEnum.RUN);
                break;
            case 2:
                equipmentData.setEquipStatus(EquipStatusEnum.ALARM);
                break;
            default:
                return false;
        }
        return true;
    }
}
