package net.vtstar.zhongtong.avi.stamping.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.scada.base.gather.domain.EquipmentData;
import net.vtstar.user.search.Search;
import net.vtstar.zhongtong.avi.global.web.Show;
import net.vtstar.zhongtong.avi.global.web.domain.enums.FieldType;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Search(code = "3D_LASER_CUTTING")
@ApiModel("激光切割机")
@Table(name = "eqp_data_3d_laser")
public class LaserCuttingMachine extends EquipmentData {

    @Search
    @Show(label = "切割速率",sortable = true)
    @ApiModelProperty("切割速率")
    @Column(name = "cutting_speed")
    private BigDecimal cuttingSpeed;

    @Search
    @Show(label = "激光器功率")
    @ApiModelProperty("激光器功率")
    @Column(name = "laser_power")
    private BigDecimal laserPower;

    @Search
    @Show(label = "气体压力")
    @ApiModelProperty("气体压力")
    @Column(name = "gas_pressure")
    private BigDecimal gasPressure;

    @Search
    @Show(label = "时间",dataType = FieldType.DATETIME)
    @ApiModelProperty("时间")
    @Column(name = "create_time")
    private Date createTime;

    private Integer state;
}
