package net.vtstar.zhongtong.avi.monitoring.domain.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.BusType;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.DateType;

import java.math.BigDecimal;

@Data
@ApiModel("车辆交进车数量统计VO")
public class CarStatisticsVO {

    private Long id;

    @ApiModelProperty(value = "区域编号")
    private String areaNo;

    @ApiModelProperty("日期类型：TODAY(今日),YESTERDAY(昨日)")
    private DateType dateType;

    @ApiModelProperty(value = "进出车类型：IN（进车） OUT（出车）")
    private BusType busType;

    @ApiModelProperty(value = "数量")
    private BigDecimal size;
}
