package net.vtstar.zhongtong.avi.monitoring.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;

@Data
@Slf4j
@ApiModel(value = "车体信息")
public class Bus {

    private Long id;

    @ApiModelProperty(value = "车间计划工单号/车身号")
    private String code;

    @ApiModelProperty(value = "销售订单号")
    private String saleOrderNo;

    @ApiModelProperty(value = "主计划工单号")
    private String planOrderNo;

    @ApiModelProperty(value = "车型")
    private String busType;

    @ApiModelProperty(value = "订单数量")
    private BigDecimal orderSize;

    @ApiModelProperty(value = "单位")
    private String unit;

    @ApiModelProperty(value = "车间")
    private String shop;

    @ApiModelProperty(value = "产线")
    private String line;

    @ApiModelProperty(value = "读取标识")
    private String flag;
}
