package net.vtstar.zhongtong.avi.monitoring.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.vtstar.utils.domain.Return;
import net.vtstar.zhongtong.avi.equipment.domain.PaintshopArea;
import net.vtstar.zhongtong.avi.equipment.domain.PaintshopStation;
import net.vtstar.zhongtong.avi.monitoring.domain.Bus;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.BusType;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.DateType;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.ProductionType;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.StationState;
import net.vtstar.zhongtong.avi.monitoring.domain.vo.CarStatisticsVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Api(description = "avi区域实时监控模块相关")
@RestController
@RequestMapping("/area")
public class AreaController {

    @ApiOperation(value = "根据区域编号查询区域实时信息", response = PaintshopArea.class, responseContainer = "List",notes = "区域编号：\r\n" +
            "整体区域：0\r\n钣金：1\r\n电泳：2\r\n密封防腐：3\r\n腻子：4\r\n中涂：5\r\n面/色漆：6\r\n成品：7")
    @GetMapping("/areaInfo/realTime")
    private Return getAreaInfo(@RequestParam(value = "areaNo",required = false) String areaNo) {
        List<PaintshopArea> areas = new ArrayList<>();
        PaintshopArea area = new PaintshopArea();
        area.setCode("2");
        area.setName("电泳");
        area.setOnlineNum("44");
        Map<String, PaintshopStation> stationMap = new HashMap<>();
        Map<String, PaintshopStation> stationMap2 = new HashMap<>();
        Map<String, PaintshopStation> stationMap3 = new HashMap<>();
        for (int i = 0; i < 9; i++) {
            PaintshopStation station = new PaintshopStation();
            station.setBusNo("No" + i);
            station.setKeyStation(true);
            station.setCode("HDG1-4" + i);
            station.setState(StationState.USE);
            station.setBusType(ProductionType.OWN);
            stationMap.put("HDG1-4" + i,station);
        }
        PaintshopArea area2 = new PaintshopArea();
        area2.setCode("1");
        area2.setName("钣金");
        area2.setOnlineNum("44");
        for (int i = 0; i < 9; i++) {
            PaintshopStation station = new PaintshopStation();
            station.setBusNo("No" + i);
            station.setKeyStation(true);
            station.setCode("HDG1-1" + i);
            station.setState(StationState.USE);
            station.setBusType(ProductionType.OWN);
            stationMap2.put("HDG1-1" + i,station);
        }
        PaintshopArea area3 = new PaintshopArea();
        area3.setCode("6");
        area3.setName("喷涂");
        area3.setOnlineNum("44");
        for (int i = 0; i < 9; i++) {
            PaintshopStation station = new PaintshopStation();
            station.setBusNo("No" + i);
            station.setKeyStation(true);
            station.setCode("HDG1-19" + i);
            station.setState(StationState.USE);
            station.setBusType(ProductionType.OWN);
            stationMap3.put("HDG1-19" + i,station);
        }
        area.setStationMap(stationMap);
        area2.setStationMap(stationMap2);
        area3.setStationMap(stationMap3);
        areas.add(area);
        areas.add(area2);
        areas.add(area3);
        return Return.success(areas);
    }

    @ApiOperation(value = "查询车间各区域进车及交车数量", response = CarStatisticsVO.class, responseContainer = "List")
    @GetMapping("/bus/statistics")
    private Return getRealtimeData() {
        ArrayList<CarStatisticsVO> vos = new ArrayList<>();
        CarStatisticsVO carStatisticsVO = new CarStatisticsVO();
        carStatisticsVO.setAreaNo("1");
        carStatisticsVO.setBusType(BusType.IN);
        carStatisticsVO.setDateType(DateType.YESTERDAY);
        carStatisticsVO.setSize(new BigDecimal(20));

        CarStatisticsVO carStatisticsVO2 = new CarStatisticsVO();
        carStatisticsVO2.setAreaNo("2");
        carStatisticsVO2.setBusType(BusType.OUT);
        carStatisticsVO2.setDateType(DateType.TODAY);
        carStatisticsVO2.setSize(new BigDecimal(20));
        vos.add(carStatisticsVO);
        vos.add(carStatisticsVO2);

        return Return.success(vos);
    }

    @ApiOperation(value = "根据工单号及订单号定位车体当前位置", response = PaintshopArea.class, responseContainer = "List")
    @GetMapping("/currentPosition/orderNo/workOrderNo")
    private Return getPositionByOrderAndNo(@RequestParam(value = "orderNo",required = false) String orderNo, @RequestParam(value = "workOrderNo",required = false) String workOrderNo) {
        List<Map<String,PaintshopStation>> s = new ArrayList<>();
        Map<String, PaintshopStation> stationMap = new HashMap<>();
        PaintshopStation station = new PaintshopStation();
        station.setBusNo("aaa");
        station.setKeyStation(true);
        station.setCode("HDG1-4");
        station.setState(StationState.USE);
        station.setBusType(ProductionType.OWN);
        stationMap.put("HDG1-4",station);
        PaintshopStation station2 = new PaintshopStation();
        station2.setBusNo("bbb");
        station2.setKeyStation(false);
        station2.setBusType(ProductionType.OTHER);
        station2.setState(StationState.FREE);
        station2.setCode("HDG1-3");
        stationMap.put("HDG1-3",station2);
        s.add(stationMap);

        return Return.success(stationMap);
    }

    @ApiOperation(value = "根据车身号获得当前车体信息", response = Bus.class)
    @GetMapping("/detail/busNo")
    private Return getBusDetail(@RequestParam("busNo") String busNo) {
        return Return.success();
    }
}
