package net.vtstar.zhongtong.avi.global.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.vtstar.utils.domain.Return;
import net.vtstar.zhongtong.avi.global.web.service.ShowFieldService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(description = "获得展示字段")
@RequestMapping("/api/field")
@RestController
public class ShowFieldController {

    @Autowired
    private ShowFieldService showFieldService;

    @ApiOperation(value = "根据searchCode获得此模块需要展示字段",notes = "现有设备类型对应searchCode：\r\n" +
            "三维激光切割机： 3D_LASER_CUTTING\r\n激光切管机： LASER_CUTTING\r\n平板激光切割机: FLAT_LASER_CUTTING\r\n" +
            "等离子切割机： PLASMA_CUTTING\r\n机器人焊接: WELDING_ROBOT\r\n前处理: PRETREATMENT\r\n" +
            "型钢数控下料：STEEL_CNC_CUTTING\r\n喷粉线：DUSTING_LINE\r\n车顶自动点焊:AUTOMATIC_SPOT_WELDING\r\n" +
            "PLC数控合装胎：PLC_CONTROL_TIRE\r\n板链：PLATE_CHAIN\r\n旋转辊床:ROTARY_ROLLER_BED\r\n" +
            "整车前处理电泳: VEHICLE_PRETREATMENT_ELECTROPHORESIS\r\n整车电泳输出: VEHICLE_ELECTROPHORESIS_OUTPUT\r\n" +
            "电泳整流: ELECTROPHORESIS_RECTIFICATION\r\n喷漆室:SPRAY_BOOTH\r\n烘干室:DRYING_ROOM\r\n" +
            "打磨室: POLISHING_ROOM\r\n喷涂机器人: PAINTING_ROBOT\r\n 过程扫码设备: PROCESS_SCAN_CODE\r\n" +
            "智能扭力扳手: INTELLIGENT_TORQUE_WRENCH\r\n润滑油集中加注:LUBRICATING_OIL_CONCENTRATE\r\n" +
            "四轮定位:WHEEL_ALIGNMENT\r\n铆接设备: RIVETING_EQUIPMENT\r\n集中加注冷媒:FOCUS_ADDING_REFRIGERANT\r\n" +
            "集中加注离合器:CENTRALIZED_FILLING_CLUTCH\r\n集中加注助力油: FOCUS_BOOSTER_OIL\r\n" +
            "地板革热熔胶涂布设备: FLOOR_LEATHER_HOT\r\n新能源在线检测点: NEW_ENERGY\r\n检测线: CHECK_LINE\r\n" +
            "充电桩: CHARGING_PILE\r\n动静态测试: DYNAMIC_STATIC_TEST\r\n加氢站: HYDROGEN_STATION\r\n" +
            "Voc处理平台:VOC_PROCESSING_PLATFORM")
    @GetMapping("/showField")
    private Return findShowFieldBySearchCode(@RequestParam("searchCode") String searchCode) {
        return Return.success(showFieldService.findShowFieldBySearchCode(searchCode));
    }
}
