package net.vtstar.zhongtong.avi.global.web;

import net.vtstar.zhongtong.avi.global.web.domain.enums.FieldType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD,ElementType.LOCAL_VARIABLE})
public @interface Show {

    /**
     * 展示字段值
     */
    String value() default "";

    /**
     * 展示字段名/标签
     */
    String label() default "";

    /**
     * 是否排序
     */
    boolean sortable() default false;

    /**
     * 数据类型
     */
    FieldType dataType() default FieldType.STRING;

    /**
     * 表头宽度
     */
    int width() default 0;
}
