package net.vtstar.zhongtong.avi.global.interceptor;

import com.alibaba.fastjson.JSONObject;
import net.vtstar.utils.domain.Return;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;

@Component
public class ParamCheckInterceptor extends HandlerInterceptorAdapter {

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		String pageNum = request.getParameter("pageNum");
		if (!StringUtils.isEmpty(pageNum) && Integer.parseInt(pageNum) < 1) {
			String msg = JSONObject.toJSONString(Return.failed("pageNum 不能小于1"));
			response.reset();
			response.setContentType("application/json;charset=UTF-8");
			try (OutputStream outputStream = response.getOutputStream()) {
				outputStream.write(msg.getBytes());
				outputStream.flush();
			}
			return false;
		}
		return true;
	}
}
