package net.vtstar.zhongtong.avi.global.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 设备运行的各种状态
 */
@ApiModel(value = "运行状态")
public enum RunningStatus {

    @ApiModelProperty(notes = "运行")
    RUN("运行"),

    @ApiModelProperty(notes = "库存")
    STOCK("库存"),

    @ApiModelProperty(notes = "故障")
    FAULT("故障");

    private String value;

    RunningStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}
