package net.vtstar.zhongtong.avi.global.domain;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Api("分页查询参数")
@Data
public class PageQueryParam {

    @ApiParam(value = "请求页码", required = true, defaultValue = "1")
    @Min(value = 0, message = "请求页码（pageNum）不能小于0")
    @NotNull(message = "pageNum is null")
    private Integer pageNum;

    @ApiParam(value = "页容量", required = true, defaultValue = "20")
    @Min(value = 0, message = "页容量（pageSize）不能小于0")
    @NotNull(message = "pageSize is null")
    private Integer pageSize;

    @ApiParam("模糊查询条件")
    private String criteria;
}
