package net.vtstar.zhongtong.avi.global.domain;

import io.swagger.annotations.ApiModel;


@ApiModel("状态")
public enum CommonStatus {

    /**
     * 已停用
     */
    STOP("0"),

    /**
     * 新建立
     */
    CREATE("1"),

    /**
     * 审核中
     */
    CHECKING("2"),

    /**
     * 审核通过
     */
    CHECK_FINISH("3"),

    /**
     * 已拒绝
     */
    RETURN("4"),

    /**
     * 生效
     */
    ENABLE("5"),

    /**
     * 失效
     */
    DISABLE("6"),

    /**
     * 已删除
     */
    DELETE("9");

    private String value;

    CommonStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}
