package net.vtstar.zhongtong.avi.global.config;

import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

@Configuration
@MapperScan(basePackages = {"net.vtstar.xiongbo.iqc.mapper.sqlserver",
        "net.vtstar.xiongbo.erp.mapper"},
        sqlSessionFactoryRef = "sqlSessionFactorySqlServer")
public class MybatisSqlServerConfig {

    @Autowired
    @Qualifier("sqlServerDatasource")
    private DataSource sqlServerDatasource;

    @Bean
    public SqlSessionFactory sqlSessionFactorySqlServer() throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(sqlServerDatasource);
        //factoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/sqlserver/*.xml"));
        return factoryBean.getObject();
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate3() throws Exception {
        SqlSessionTemplate template = new SqlSessionTemplate(sqlSessionFactorySqlServer()); // 使用上面配置的Factory
        return template;
    }
}
