package net.vtstar.zhongtong.avi.equipment.service;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import lombok.extern.slf4j.Slf4j;
import net.vtstar.scada.base.gather.domain.EquipmentData;
import net.vtstar.user.mybatis.provider.Operation;
import net.vtstar.user.mybatis.provider.OrderBy;
import net.vtstar.user.mybatis.provider.WhereFilter;
import net.vtstar.user.search.service.SearchService;
import net.vtstar.zhongtong.avi.equipment.domain.*;
import net.vtstar.zhongtong.avi.equipment.mapper.BasicInfoMapper;
import net.vtstar.zhongtong.avi.equipment.mapper.EquipmentDataMapper;
import net.vtstar.zhongtong.avi.equipment.mapper.FaultRecordMapper;
import net.vtstar.zhongtong.avi.equipment.mapper.RuntimeRecordMapper;
import net.vtstar.zhongtong.avi.stamping.domain.LaserCuttingMachine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 17:23
 */
@Slf4j
@Service
public class RunRecordService {

    @Autowired
    private RuntimeRecordMapper runtimeRecordMapper;

    @Autowired
    private FaultRecordMapper faultRecordMapper;

    @Autowired
    private SearchService searchService;

    @Autowired
    private BasicInfoMapper basicInfoMapper;

    @Autowired
    private EquipmentDataMapper equipmentData;

    /**
     * 分页查询运行时间
     */
    public List<RuntimeRecord> findPageRunTime(JSONObject pageFilter) {
        PageHelper.startPage(pageFilter.getIntValue("pageNum"), pageFilter.getIntValue("pageSize"));
        return runtimeRecordMapper.findList(searchService.pageFilter2Filter(pageFilter, new WhereFilter() {{
            addJoin(RuntimeRecord.class, "machine_id", EquipInfo.class, "id");
        }}), RuntimeRecord.class);
    }

    /**
     * 分页查询报警记录
     */
    public List<FaultRecord> findPageFault(JSONObject pageFilter) {
        PageHelper.startPage(pageFilter.getIntValue("pageNum"), pageFilter.getIntValue("pageSize"));
        return faultRecordMapper.findList(searchService.pageFilter2Filter(pageFilter, new WhereFilter() {{
            addJoin(PaintshopStation.class, "area_id", PaintshopArea.class, "id");
            addJoin(PaintshopStation.class, "lane_id", PaintshopLane.class, "id");
            addOrderBy(PaintshopStation.class, "sequence", OrderBy.ASC);
        }}), PaintshopStation.class);
    }


    /**
     * 根据设备编码查询上一条运行时间记录
     */
    public RuntimeRecord getLastByCode(String eqpCode) {
        List<RuntimeRecord> list = runtimeRecordMapper.findList(new WhereFilter() {{
            addJoin(RuntimeRecord.class, "machine_id", EquipInfo.class, "id");
            addFilter(EquipInfo.class, "equip_code", Operation.EQUAL, eqpCode);
            addOrderBy(RuntimeRecord.class, "create_time", OrderBy.DESC);
            setRows(0);
            setOffset(1);
        }}, RuntimeRecord.class);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        } else {
            return list.get(0);
        }
    }

    public void test() {
        EquipmentData laser = new LaserCuttingMachine();
        ((LaserCuttingMachine) laser).setCuttingSpeed(new BigDecimal(500));



        RuntimeRecord runtimeRecord = new RuntimeRecord();
        runtimeRecord.setWorkshopCode("23232");

        equipmentData.insert(runtimeRecord);
    }

    public static void main(String[] args) {
    }
}
