package net.vtstar.zhongtong.avi.equipment.service;

import net.vtstar.user.search.controller.vo.SearchVo;
import net.vtstar.zhongtong.avi.stamping.domain.LaserCuttingMachine;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class EquipmentService {

    @Autowired
    private EquipmentService equipmentService;

    public <T> T findRealTimeData(SearchVo pageFilter) {
        List<LaserCuttingMachine> ma = new ArrayList<>();
        LaserCuttingMachine machine = new LaserCuttingMachine();
        machine.setBeginTime(new Date());
        machine.setAlias("设备1");
        machine.setEquipCode("511111");
        machine.setCuttingSpeed(new BigDecimal(555));
        machine.setGasPressure(new BigDecimal(477));
        machine.setCreateTime(new Date());
        machine.setLaserPower(new BigDecimal(77777));
        ma.add(machine);
        return (T) ma;
    }

    public void orderExport(HttpServletResponse response) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("0");
        sheet.setColumnWidth(0, 4000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 3000);
        sheet.setColumnWidth(3, 2000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 3000);
        sheet.setColumnWidth(6, 4000);
        sheet.setColumnWidth(7, 4000);
        sheet.setColumnWidth(8, 4000);
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderTop(BorderStyle.DASHED);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);

        cellStyle.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());

        XSSFFont titleFont = wb.createFont();
        titleFont.setFontHeight(24);
        titleFont.setBold(true);

        String[] title = {"设备名称", "设备编码", "设备状态"};
        int rowNumber = 0;

        XSSFRow row = sheet.createRow(rowNumber);
        rowNumber++;
        for (int i = 0; i < title.length; i++) {
            row.createCell(i).setCellValue(title[i]);
        }
        response.setCharacterEncoding("utf-8");

        String filename = URLEncoder.encode("测试报表", "utf-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".xlsx");
        response.setHeader("filename", filename + ".xlsx");

        try {
            ServletOutputStream outputStream = response.getOutputStream();
            wb.write(outputStream);
            outputStream.flush();
            outputStream.close();
        } catch (IOException e) {
            throw new IOException("报表导出失败!");
        }
    }
}
