package net.vtstar.zhongtong.avi.equipment.job;

import lombok.extern.slf4j.Slf4j;
import net.vtstar.scada.base.equipmgt.service.EquipDataService;
import net.vtstar.scada.base.gather.domain.EquipmentData;
import net.vtstar.user.mybatis.provider.Operation;
import net.vtstar.user.mybatis.provider.WhereFilter;
import net.vtstar.zhongtong.avi.equipment.domain.EquipInfo;
import net.vtstar.zhongtong.avi.equipment.domain.RuntimeRecord;
import net.vtstar.zhongtong.avi.equipment.mapper.BasicInfoMapper;
import net.vtstar.zhongtong.avi.equipment.mapper.RuntimeRecordMapper;
import net.vtstar.zhongtong.avi.equipment.service.RunRecordService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


/**
 * 统计运行时间job
 */
@Slf4j
public class StatisticsTimeJob extends QuartzJobBean {

    @Autowired
    private EquipDataService equipDataService;
    @Autowired
    private RunRecordService runRecordService;
    @Autowired
    private BasicInfoMapper basicInfoMapper;
    @Autowired
    private RuntimeRecordMapper runtimeRecordMapper;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Calendar instance = Calendar.getInstance();
        instance.add(Calendar.DATE, -1);
        Date yesterday = instance.getTime();

        //拿到所有设备
        List<EquipInfo> equipInfo = basicInfoMapper.findList(new WhereFilter(),EquipInfo.class);

        for (EquipInfo info : equipInfo) {
            String equipCode = info.getEquipCode();
            long totalRuntime = 0;
            //查询今日设备所有运行状态数据
            List<EquipmentData> runData = equipDataService.findRunByCodeAndDate(equipCode, yesterday);
            if (CollectionUtils.isEmpty(runData)) {
                continue;
            }
            //计算运行时间
            for (EquipmentData data : runData) {
                long runtime = data.getEndTime().getTime() - data.getBeginTime().getTime();
                totalRuntime += runtime;
            }
            //生成运行时间记录
            RuntimeRecord lastRecord = runRecordService.getLastByCode(equipCode);
            RuntimeRecord runtimeRecord = new RuntimeRecord();
            runtimeRecord.setCreateTime(new Date());
            BigDecimal hours = new BigDecimal(totalRuntime).divide(new BigDecimal(3600000), 4, BigDecimal.ROUND_HALF_UP);
            runtimeRecord.setCurrentRuntime(hours);
            BigDecimal total = BigDecimal.ZERO;
            if (null != lastRecord) {
                total = lastRecord.getTotalRuntime();
            }
            runtimeRecord.setTotalRuntime(total.add(hours));
            List<EquipInfo> list = basicInfoMapper.findList(new WhereFilter() {{
                addFilter(EquipInfo.class, "equip_code", Operation.EQUAL, equipCode);
            }}, EquipInfo.class);
            EquipInfo eqp = list.get(0);
            runtimeRecord.setMachineId(eqp.getId());
            runtimeRecord.setWorkshopCode(eqp.getWorkshopCode());
            List<RuntimeRecord> records = new ArrayList<>();
            records.add(runtimeRecord);
            runtimeRecordMapper.insertLists(records);
        }
    }
}
