package net.vtstar.zhongtong.avi.equipment.job;

import lombok.extern.slf4j.Slf4j;
import net.vtstar.scada.base.equipmgt.service.EquipDataService;
import net.vtstar.scada.base.gather.domain.EquipmentData;
import net.vtstar.scada.base.redis.service.SimpleRedisService;
import net.vtstar.scada.base.redis.util.EquipDataUtil;
import net.vtstar.zhongtong.avi.equipment.mapper.EquipmentDataMapper;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;

@Slf4j
@Component
@DisallowConcurrentExecution
public class CleanStatusDataJob extends QuartzJobBean {


    @Resource(name = "redisTemplate")
    private RedisTemplate redisTemplate;
    @Autowired
    private EquipDataService equipDataService;
    @Autowired
    private SimpleRedisService simpleRedisService;
    @Autowired
    private EquipmentDataMapper equipmentDataMapper;

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {

        log.info("_______________________________________________________________");
        log.info("开始清洗设备状态数据...");
        Set<String> keys = redisTemplate.keys(EquipDataUtil.getStatusKey("*"));
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        log.info("开始清洗设备状态数据 key.size: {}", keys.size());

        for (String key : keys) {
            List<EquipmentData> dataList = (List<EquipmentData>) simpleRedisService.getListDelDefaultSize(key);
            if (CollectionUtils.isEmpty(dataList)) {
                continue;
            }
            //插入设备监控数据
            equipmentDataMapper.insertList(dataList);
            equipDataService.updateLastStatus(dataList.get(dataList.size() - 1));

            String equipCode = dataList.get(0).getEquipCode();
            EquipmentData last = equipDataService.getLast(equipCode);
            final EquipmentData first = last;
            int index = 1;
            for (int i = 0; i < dataList.size(); i++) {

                if (last == null) {
                    last = dataList.get(0);
                    continue;
                }

                if (last.getBeginTime() == null || last.getEquipStatus() == null) {
                    redisTemplate.delete(key);
                    break;
                }

                EquipmentData d = dataList.get(i);
                last.setEndTime(d.getBeginTime());

                if (d.getEquipStatus() != last.getEquipStatus()) {

                    if (index == 1) {
                        equipDataService.update(last);
                    } else {
                        // 保存
                        equipDataService.save(last);
                    }
                    last = d;
                    index++;
                }
            }

            if (first != null && first.getBeginTime().equals(last.getBeginTime())) {
                equipDataService.update(last);
            } else {
                equipDataService.save(last);
            }

        }
    }
}
