package net.vtstar.zhongtong.avi.equipment.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.user.search.JoinColumn;
import net.vtstar.user.search.Search;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 17:29
 */
@ApiModel("设备运行时间")
@Data
@Search(code = "MACHINE_RUNTIME_RECORD")
@Table(name = "machine_runtime_record")
public class RuntimeRecord {

    @Id
    private Long id;

    @ApiModelProperty(notes = "车间")
    @Column(name = "workshop_code")
    @Search
    private String workshopCode;

    @ApiModelProperty(notes = "设备ID")
    @Column(name = "machine_id")
    private Long machineId;

    @ApiModelProperty(notes = "设备编号")
    @JoinColumn(tableName = EquipInfo.class, name = "equip_code")
    private String equipCode;

    @ApiModelProperty(notes = "设备名称")
    @JoinColumn(tableName = EquipInfo.class, name = "alias")
    @Search
    private String alias;

    @ApiModelProperty(notes = "当前运行时间")
    @Column(name = "current_runtime")
    private BigDecimal currentRuntime;

    @ApiModelProperty(notes = "累计运行时间")
    @Column(name = "total_runtime")
    private BigDecimal totalRuntime;

    @ApiModelProperty(notes = "创建时间")
    @Column(name = "create_time")
    private Date createTime;
}
