package net.vtstar.zhongtong.avi.equipment.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.user.search.JoinColumn;
import net.vtstar.user.search.Search;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.BusType;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.ProductionType;
import net.vtstar.zhongtong.avi.monitoring.domain.enums.StationState;
import org.hibernate.validator.constraints.Length;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 9:31
 */
@ApiModel("喷涂车间_工位")
@Data
@Search(code = "PAINTSHOP_STATION")
@Table(name = "paintshop_station")
public class PaintshopStation {

    @Id
    private Long id;

    @ApiModelProperty(notes = "车间")
    @NotNull(message = "车间不能为空")
    @Length(max = 20, message = "车间名称长度不能大于{max}")
    @Column(name = "workshop_code")
    @Search
    private String workshopCode;

    @ApiModelProperty(notes = "区域ID")
    @NotNull(message = "区域ID不能为空")
    @Column(name = "area_id")
    private Long areaId;

    @ApiModelProperty(notes = "区域")
    @JoinColumn(tableName = PaintshopArea.class, name = "name")
    @Search
    private String areaName;

    @ApiModelProperty(notes = "车道ID")
    @NotNull(message = "车道ID不能为空")
    @Column(name = "lane_id")
    private Long laneId;

    @ApiModelProperty(notes = "车道编号")
    @JoinColumn(tableName = PaintshopLane.class, name = "code")
    @Search
    private String laneCode;

    @ApiModelProperty(notes = "工位编号")
    @NotNull(message = "工位编号不能为空")
    @Column(name = "code")
    private String code;

    @ApiModelProperty(notes = "状态")
    @Column(name = "state")
    private StationState state;

    @ApiModelProperty(notes = "滑撬ID")
    @Column(name = "skid_id")
    private Long skidID;

    @ApiModelProperty(notes = "序号")
    @NotNull(message = "工位序号不能为空")
    @Column(name = "sequence")
    private Integer sequence;

    @ApiModelProperty(notes = "是否为关键工位")
    @Column(name = "key_station")
    private Boolean keyStation;

    @ApiModelProperty(notes = "车身号")
    private String busNo;

    @ApiModelProperty(value = "车体类型")
    private ProductionType busType;
}
