package net.vtstar.zhongtong.avi.equipment.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.user.search.Search;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.List;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 9:31
 */
@ApiModel("喷涂车间_车道")
@Data
@Table(name = "paintshop_lane")
public class PaintshopLane {

    @Id
    private Long id;

    @ApiModelProperty(notes = "区域ID")
    @Column(name = "area_id")
    private Long areaId;

    @ApiModelProperty(notes = "车道编号")
    @Column(name = "code")
    private String code;

    @ApiModelProperty(notes = "车道名称")
    @Column(name = "name")
    private String name;

    @ApiModelProperty(notes = "在线数量")
    @Column(name = "online_num")
    private Integer onlineNum;

    private List<PaintshopStation> stationList;
}
