package net.vtstar.zhongtong.avi.equipment.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.user.search.Search;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.List;
import java.util.Map;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 9:31
 */
@ApiModel("喷涂车间_区域")
@Data
@Table(name = "paintshop_area")
public class PaintshopArea {

    @Id
    private Long id;

    @ApiModelProperty(notes = "区域编号")
    @Column(name = "code")
    private String code;

    @ApiModelProperty(notes = "区域名称")
    @Column(name = "name")
    private String name;

    @ApiModelProperty(notes = "在线数量")
    @Column(name = "online_num")
    private String onlineNum;

    private Map<String,PaintshopStation> stationMap;

    @ApiModelProperty(notes = "下属区域",hidden = true)
    private List<PaintshopLane> laneList;
}
