package net.vtstar.zhongtong.avi.equipment.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.user.search.JoinColumn;
import net.vtstar.user.search.Search;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 17:30
 */
@ApiModel("设备故障记录表")
@Data
@Search(code = "MACHINE_WARNING_RECORD")
@Table(name = "machine_warning_record")
public class FaultRecord {

    @Id
    private Long id;

    @ApiModelProperty(notes = "车间")
    @Column(name = "workshop_code")
    @Search
    private String workshopCode;

    @ApiModelProperty(notes = "设备ID")
    @Column(name = "machine_id")
    private Long machineId;

    @ApiModelProperty(notes = "设备编号")
    @JoinColumn(tableName = EquipInfo.class, name = "equipCode")
    @Search
    private String equipCode;

    @ApiModelProperty(notes = "设备名称")
    @JoinColumn(tableName = EquipInfo.class, name = "alias")
    @Search
    private String alias;

    @ApiModelProperty(notes = "故障信息")
    @Column(name = "warning_info")
    private String warningInfo;

    @ApiModelProperty(notes = "开始时间")
    @Column(name = "begin_time")
    private Date beginTime;

}
