package net.vtstar.zhongtong.avi.equipment.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.vtstar.user.search.Search;
import org.hibernate.validator.constraints.Length;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 9:31
 */
@ApiModel("设备表")
@Data
@Search(code = "SCADA_EQUIP_INFO")
@Table(name = "scada_equip_info")
public class EquipInfo {

    @Id
    private Long id;

    @ApiModelProperty(notes = "车间编号")
    @NotNull(message = "车间编号不能为空")
    @Length(max = 20, message = "车间编号长度不能大于{max}")
    @Column(name = "workshop_code")
    @Search
    private String workshopCode;

    @ApiModelProperty(notes = "车间名称")
    @NotNull(message = "车间名称不能为空")
    @Length(max = 50, message = "车间名称长度不能大于{max}")
    @Column(name = "workshop_name")
    @Search
    private String workshopName;

    @ApiModelProperty(notes = "设备分类")
    @NotNull(message = "设备分类不能为空")
    @Length(max = 50, message = "设备分类长度不能大于{max}")
    @Column(name = "equip_type")
    @Search
    private String equipType;

    @ApiModelProperty(notes = "设备编号")
    @NotNull(message = "设备名称不能为空")
    @Length(max = 100, message = "设备编号长度不能大于{max}")
    @Column(name = "equip_code")
    @Search
    private String equipCode;

    @ApiModelProperty(notes = "设备名称")
    @Length(max = 100, message = "设备名称长度不能大于{max}")
    @Column(name = "alias")
    @Search
    private String alias;

    @ApiModelProperty(notes = "设备厂商")
    @Length(max = 100, message = "设备厂商长度不能大于{max}")
    @Column(name = "equip_factory")
    private String equipFactory;

    @ApiModelProperty(notes = "创建时间")
    @Column(name = "create_time")
    private Date createTime;

    @ApiModelProperty(notes = "更新时间")
    @Column(name = "update_time")
    private Date updateTime;
}
