package net.vtstar.zhongtong.avi.equipment.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.vtstar.user.search.controller.vo.SearchVo;
import net.vtstar.utils.domain.Return;
import net.vtstar.zhongtong.avi.equipment.service.RunRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: xiadongwei
 * @Date: 2019/9/20 17:22
 */
@Slf4j
@Api(description = "设备运行记录模块(运行时间/告警)")
@RequestMapping("/api/equipment")
@RestController
public class RunRecordController {

    @Autowired
    private RunRecordService runRecordService;

    @ApiOperation(value = "运行时间列表(分页查询)", notes = "使用通用搜索组件，searchCode：MACHINE_RUNTIME_RECORD\n" +
            "字段含义：\n{\n" +
            "  \"workshopCode\": \"车间，字符串类型\",\n" +
            "  \"equipCode\": \"设备编号，字符串类型\",\n" +
            "  \"alias\": \"设备名称，字符串类型\"\n" +
            "  \"currentRuntime\": \"当班运行时间，LONG\"\n" +
            "  \"totalRuntime\": \"累计运行时间，LONG\"\n" +
            "}")
    @PostMapping("/runtimePage")
    public Return pageListRuntime(@RequestBody SearchVo pageFilter) {
        return Return.success(new PageInfo<>(runRecordService.findPageRunTime(pageFilter.toJSONObject())));
    }

    @ApiOperation(value = "故障信息列表(分页查询)", notes = "使用通用搜索组件，searchCode：MACHINE_WARNING_RECORD\n" +
            "字段含义：\n{\n" +
            "  \"workshopCode\": \"车间，字符串类型\",\n" +
            "  \"equipCode\": \"设备编号，字符串类型\",\n" +
            "  \"alias\": \"设备名称，字符串类型\"\n" +
            "  \"warningInfo\": \"故障信息，字符串类型\"\n" +
            "  \"beginTime\": \"时间，Date\"\n" +
            "}")
    @PostMapping("/faultPage")
    public Return pageListFault(@RequestBody SearchVo pageFilter) {
        return Return.success(new PageInfo<>(runRecordService.findPageFault(pageFilter.toJSONObject())));
    }

    @GetMapping("/test")
    public Return test(){
        runRecordService.test();
        return Return.success();
    }
}
