package net.vtstar.zhongtong.avi.equipment.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.vtstar.scada.base.equipmgt.domain.EquipInfo;
import net.vtstar.user.search.controller.vo.SearchVo;
import net.vtstar.utils.domain.Return;
import net.vtstar.zhongtong.avi.equipment.domain.Program;
import net.vtstar.zhongtong.avi.equipment.domain.vo.ProgramTransferVO;
import net.vtstar.zhongtong.avi.equipment.service.EquipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Api(description = "设备模块")
@RequestMapping("/api/equipment")
@RestController
public class EquipmentController {

    @Autowired
    private EquipmentService equipmentService;

    @ApiOperation(value = "获取设备监控数据(分页)", notes = "各车间对应code:\r\n" +
            "制件车间: PARTS\r\n焊装车间: WELDING\r\n涂装车间: PAINTING\r\n" +
            "底盘车间: CHASSIS\r\n总装车间: ASSEMBLY\r\n试交车间: TRIAL\r\n" +
            "")
    @PostMapping(value = "/realTime/data")
    private Return getRealTimeData(@RequestBody SearchVo pageFilter) {
        Object realTimeData = equipmentService.findRealTimeData(pageFilter);
        List<Map<String, Object>> data = (List<Map<String, Object>>) realTimeData;
        return Return.success(new PageInfo<>(data));
    }

    @ApiOperation(value = "根据设备类型和车间code获得设备列表")
    @GetMapping("/equip/findByType")
    private Return findEquipByShopAndType(@RequestParam String workshopCode,@RequestParam String equipType){
        List<EquipInfo> equipInfos = new ArrayList<>();
        EquipInfo equipInfo = new EquipInfo();
        equipInfo.setEquipCode("mingshao");
        equipInfo.setEquipName("李氏集团");
        EquipInfo equipInfo2 = new EquipInfo();
        equipInfo2.setEquipCode("mingshao2");
        equipInfo2.setEquipName("李氏集团2");
        equipInfos.add(equipInfo);
        equipInfos.add(equipInfo2);
        return Return.success(equipInfos);
    }

    @ApiOperation(value = "程序传输")
    @PostMapping("/program/transfer")
    private Return programTransfer(@RequestBody ProgramTransferVO transferVO){

        return Return.success();
    }

    @ApiOperation(value = "报表导出")
    @PostMapping("/data/export")
    private Return dataExport(@RequestBody SearchVo pageFilter,HttpServletResponse response) throws UnsupportedEncodingException {

        try {
            equipmentService.orderExport(response);
        } catch (Exception e) {
            String message = URLEncoder.encode("报表导出失败", "utf-8").replaceAll("\\+", "%20");
            response.setHeader("status","601");
            response.setHeader("message", message);
            log.error(e.getMessage(),e);
            return Return.failed("内部错误");
        }
        return Return.success();
    }

    @ApiOperation("文件上传")
    @PostMapping("/file/upload")
    public Return uploadNcFile(@RequestParam("file") MultipartFile file){
        Program program = new Program();
        program.setPath("D:/test/a.txt");
        return Return.success(program);
    }
}
