import os
import random
from datetime import datetime

from flask import Flask, request

app = Flask(__name__)

UPLOAD_FOLDER = "uploads"
os.makedirs(UPLOAD_FOLDER, exist_ok=True)


@app.route("/upload", methods=["POST"])
def upload_file():
    if "file" not in request.files:
        return "No file part"

    file = request.files["file"]

    res = random.choice(["ok", "fail"])
    if res == "fail":
        return res
    if file.filename == "":
        return "No selected file"

    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    save_path = os.path.join(UPLOAD_FOLDER, timestamp + '_' + file.filename)
    file.save(save_path)

    return res


if __name__ == "__main__":
    app.run(host="0.0.0.0", port=5000, debug=True)
