# Jingke POC Demo

这是一个基于 Flask 的简单文件上传服务的 POC (Proof of Concept) 演示项目。

## 功能说明

该应用提供了一个简单的文件上传接口，将上传的文件保存到服务器的 `uploads` 目录中。每次上传有 50% 的概率返回成功或失败状态。

## 技术栈

- Python 3.12
- Flask 3.1.2
- uv 包管理工具

## 运行方式

### 本地运行

1. 安装依赖：
   ```bash
   pip install uv
   uv sync
   ```

2. 运行应用：
   ```bash
   python main.py
   ```

### Docker 运行

构建并运行 Docker 镜像：
```bash
docker build -t jingke-poc-demo .
docker run -p 5000:5000 jingke-poc-demo
```

## API 接口

### 文件上传

- **URL**: `/upload`
- **方法**: POST
- **参数**: `file` (表单数据中的文件)
- **响应**: 
  - 成功时返回 "ok"
  - 失败时返回 "fail"

## 注意事项

这是一个概念验证项目，仅用于演示目的，不建议在生产环境中使用。